/// <summary>
/// Nutty Software Open WebGL Framework
/// 
/// Copyright (C) 2012 Nathaniel Meyer
/// Nutty Software, http://www.nutty.ca
/// All Rights Reserved.
/// 
/// Permission is hereby granted, free of charge, to any person obtaining a copy of
/// this software and associated documentation files (the "Software"), to deal in
/// the Software without restriction, including without limitation the rights to
/// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
/// of the Software, and to permit persons to whom the Software is furnished to do
/// so, subject to the following conditions:
///     1. The above copyright notice and this permission notice shall be included in all
///        copies or substantial portions of the Software.
///     2. Redistributions in binary or minimized form must reproduce the above copyright
///        notice and this list of conditions in the documentation and/or other materials
///        provided with the distribution.
/// 
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
/// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
/// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
/// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
/// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
/// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
/// SOFTWARE.
/// </summary>


/// <summary>
/// This script is responsible for creating the scene entities for the demo.
/// </summary>


/// <summary>
/// Constructor.
/// </summary>
function HdrSceneGen ()
{
}


// Geometry for the building entity
HdrSceneGen.BuildingVertices = [-0.980000,0.980000,-1.000000,0.980000,0.980000,-1.000000,-0.980000,0.980000,1.000000,0.980000,0.980000,1.000000,-0.980000,1.000000,1.000000,0.980000,1.000000,1.000000,-0.980000,1.000000,-1.000000,0.980000,1.000000,-1.000000,0.485000,0.980000,1.000000,-0.505000,0.980000,-1.000000,-0.505000,0.980000,1.000000,0.485000,0.980000,-1.000000,-0.980000,0.980000,-0.750000,0.732500,0.980000,1.000000,0.980000,0.980000,-0.750000,-0.752500,0.980000,-1.000000,-0.980000,0.980000,0.750000,-0.752500,0.980000,1.000000,0.980000,0.980000,0.750000,0.732500,0.980000,-1.000000,0.237500,0.980000,1.000000,-0.257500,0.980000,-1.000000,-0.980000,0.980000,0.250000,-0.257500,0.980000,1.000000,0.980000,0.980000,0.250000,0.237500,0.980000,-1.000000,0.485000,0.980000,-0.750000,0.485000,0.980000,0.750000,0.485000,0.980000,0.250000,-0.505000,0.980000,0.750000,-0.505000,0.980000,0.250000,-0.505000,0.980000,-0.750000,0.732500,0.980000,-0.750000,0.732500,0.980000,0.250000,-0.257500,0.980000,0.250000,-0.257500,0.980000,-0.750000,0.237500,0.980000,-0.750000,0.732500,0.980000,0.750000,0.237500,0.980000,0.750000,0.237500,0.980000,0.250000,-0.257500,0.980000,0.750000,-0.752500,0.980000,0.750000,-0.752500,0.980000,0.250000,-0.752500,0.980000,-0.750000,0.485000,1.000000,1.000000,0.485000,1.000000,-1.000000,-0.505000,1.000000,1.000000,-0.505000,1.000000,-1.000000,0.732500,1.000000,1.000000,0.732500,1.000000,-1.000000,0.980000,1.000000,-0.750000,-0.980000,1.000000,0.750000,-0.752500,1.000000,1.000000,-0.752500,1.000000,-1.000000,0.980000,1.000000,0.750000,-0.980000,1.000000,-0.750000,0.237500,1.000000,1.000000,0.237500,1.000000,-1.000000,-0.980000,1.000000,0.250000,-0.257500,1.000000,1.000000,-0.257500,1.000000,-1.000000,0.980000,1.000000,0.250000,0.485000,1.000000,0.250000,0.485000,1.000000,0.750000,0.485000,1.000000,-0.750000,-0.505000,1.000000,-0.750000,-0.505000,1.000000,0.250000,-0.505000,1.000000,0.750000,0.732500,1.000000,0.750000,-0.257500,1.000000,0.750000,0.732500,1.000000,0.250000,0.237500,1.000000,0.250000,0.237500,1.000000,0.750000,0.732500,1.000000,-0.750000,0.237500,1.000000,-0.750000,-0.257500,1.000000,-0.750000,-0.752500,1.000000,-0.750000,-0.257500,1.000000,0.250000,-0.752500,1.000000,0.250000,-0.752500,1.000000,0.750000,-1.000000,0.980000,-1.000000,-1.000000,0.980000,1.000000,-1.000000,1.000000,1.000000,-1.000000,1.000000,-1.000000,-1.000000,0.980000,-0.750000,-1.000000,0.980000,0.750000,-1.000000,0.980000,0.250000,-1.000000,1.000000,0.750000,-1.000000,1.000000,-0.750000,-1.000000,1.000000,0.250000,-0.980000,-0.980000,-1.000000,-0.980000,-0.980000,1.000000,-0.980000,-0.980000,-0.750000,-0.980000,-0.980000,0.750000,-0.980000,-0.980000,0.250000,-1.000000,-0.980000,-1.000000,-1.000000,-0.980000,1.000000,-1.000000,-0.980000,-0.750000,-1.000000,-0.980000,0.750000,-1.000000,-0.980000,0.250000,-0.980000,-1.000000,-1.000000,-0.980000,-1.000000,1.000000,-0.980000,-1.000000,-0.750000,-0.980000,-1.000000,0.750000,-0.980000,-1.000000,0.250000,-1.000000,-1.000000,-1.000000,-1.000000,-1.000000,1.000000,-1.000000,-1.000000,-0.750000,-1.000000,-1.000000,0.750000,-1.000000,-1.000000,0.250000,0.980000,-0.980000,-1.000000,0.980000,-0.980000,1.000000,0.980000,-0.980000,-0.750000,0.980000,-0.980000,0.750000,0.980000,-0.980000,0.250000,0.980000,-1.000000,-1.000000,0.980000,-1.000000,1.000000,0.980000,-1.000000,-0.750000,0.980000,-1.000000,0.750000,0.980000,-1.000000,0.250000,1.000000,-0.980000,-1.000000,1.000000,-0.980000,1.000000,1.000000,-0.980000,-0.750000,1.000000,-0.980000,0.750000,1.000000,-0.980000,0.250000,1.000000,-1.000000,-1.000000,1.000000,-1.000000,1.000000,1.000000,-1.000000,-0.750000,1.000000,-1.000000,0.750000,1.000000,-1.000000,0.250000,1.000000,0.980000,-1.000000,1.000000,0.980000,1.000000,1.000000,1.000000,1.000000,1.000000,1.000000,-1.000000,1.000000,0.980000,-0.750000,1.000000,0.980000,0.750000,1.000000,0.980000,0.250000,1.000000,1.000000,-0.750000,1.000000,1.000000,0.750000,1.000000,1.000000,0.250000,0.485000,0.980000,-1.000000,0.732500,0.980000,-1.000000,-0.505000,0.980000,-1.000000,0.732500,0.980000,0.250000,0.732500,0.980000,-0.750000,0.237500,0.980000,-0.750000,0.485000,0.980000,-0.750000,0.732500,0.980000,0.750000,0.732500,0.980000,0.750000,0.485000,0.980000,0.750000,0.237500,0.980000,0.750000,0.237500,0.980000,0.250000,0.237500,0.980000,1.000000,-0.257500,0.980000,0.250000,-0.257500,0.980000,0.750000,-0.505000,0.980000,0.750000,-0.505000,0.980000,0.750000,-0.752500,0.980000,0.750000,-0.752500,0.980000,0.750000,-0.980000,0.980000,0.750000,-0.257500,0.980000,0.250000,-0.752500,0.980000,-0.750000,-0.752500,0.980000,0.250000,-0.752500,0.980000,-1.000000,0.732500,1.000000,0.750000,0.485000,1.000000,1.000000,0.732500,1.000000,1.000000,-0.505000,1.000000,1.000000,0.237500,1.000000,0.750000,0.485000,1.000000,0.750000,0.237500,1.000000,1.000000,0.237500,1.000000,0.250000,0.732500,1.000000,-0.750000,0.485000,1.000000,-0.750000,0.237500,1.000000,-0.750000,0.237500,1.000000,0.250000,-0.505000,1.000000,-0.750000,-0.752500,1.000000,-0.750000,-0.257500,1.000000,0.250000,-0.257500,1.000000,-0.750000,-0.505000,1.000000,-0.750000,-0.257500,1.000000,0.250000,-0.752500,1.000000,-0.750000,-0.980000,1.000000,-0.750000,-0.752500,1.000000,0.750000,-0.752500,1.000000,0.250000,-0.752500,1.000000,1.000000,0.732500,1.000000,-0.750000,0.732500,1.000000,0.250000,0.732500,1.000000,1.000000,0.732500,0.980000,1.000000,0.732500,0.980000,1.000000,0.732500,1.000000,1.000000,0.485000,1.000000,1.000000,0.237500,1.000000,1.000000,0.237500,0.980000,1.000000,0.485000,0.980000,1.000000,-0.257500,1.000000,1.000000,-0.257500,0.980000,1.000000,0.237500,0.980000,1.000000,-0.257500,0.980000,1.000000,-0.257500,1.000000,1.000000,-0.505000,1.000000,1.000000,-0.752500,1.000000,1.000000,-0.752500,0.980000,1.000000,-0.505000,0.980000,1.000000,-0.752500,0.980000,1.000000,-0.752500,1.000000,1.000000,-0.980000,1.000000,1.000000,-0.980000,0.980000,1.000000,-0.980000,1.000000,1.000000,-1.000000,1.000000,1.000000,-0.980000,1.000000,1.000000,-0.980000,0.980000,-1.000000,-1.000000,0.980000,-0.750000,-0.980000,0.980000,1.000000,-0.980000,1.000000,0.250000,-0.980000,1.000000,-0.750000,-0.980000,1.000000,-1.000000,-1.000000,1.000000,0.250000,-1.000000,1.000000,0.750000,-0.980000,1.000000,0.750000,-1.000000,0.980000,-0.750000,-1.000000,1.000000,-0.750000,-1.000000,1.000000,-1.000000,-1.000000,0.980000,0.250000,-1.000000,1.000000,0.250000,-1.000000,1.000000,-0.750000,-1.000000,1.000000,0.750000,-1.000000,1.000000,0.250000,-1.000000,1.000000,0.750000,-1.000000,0.980000,0.750000,-0.980000,-0.980000,-0.750000,-0.980000,0.980000,-0.750000,-0.980000,0.980000,0.750000,-0.980000,0.980000,1.000000,-0.980000,-0.980000,1.000000,-1.000000,-0.980000,1.000000,-1.000000,0.980000,1.000000,-0.980000,-0.980000,0.250000,-0.980000,0.980000,0.250000,-1.000000,0.980000,0.750000,-1.000000,0.980000,0.250000,-1.000000,-0.980000,-0.750000,-1.000000,-0.980000,-1.000000,-0.980000,-0.980000,0.250000,-1.000000,-0.980000,1.000000,-0.980000,-0.980000,1.000000,-1.000000,-0.980000,0.750000,-1.000000,-0.980000,0.250000,-1.000000,-0.980000,0.250000,-1.000000,-0.980000,-0.750000,0.980000,-0.980000,0.250000,-0.980000,-0.980000,-0.750000,-1.000000,-1.000000,1.000000,-0.980000,-1.000000,1.000000,-0.980000,-0.980000,1.000000,-0.980000,-1.000000,-0.750000,-1.000000,-1.000000,-0.750000,-1.000000,-1.000000,-1.000000,-1.000000,-1.000000,0.250000,-1.000000,-1.000000,-0.750000,-1.000000,-1.000000,0.750000,-1.000000,-1.000000,0.250000,-1.000000,-1.000000,0.750000,-0.980000,-1.000000,0.750000,-0.980000,-1.000000,1.000000,-0.980000,-1.000000,0.250000,-0.980000,-1.000000,-0.750000,-0.980000,-0.980000,0.750000,-0.980000,-0.980000,1.000000,-0.980000,-1.000000,0.750000,-0.980000,-1.000000,0.250000,0.980000,-0.980000,-0.750000,-0.980000,-0.980000,-1.000000,0.980000,-1.000000,1.000000,-0.980000,-1.000000,1.000000,0.980000,0.980000,0.750000,0.980000,-0.980000,0.750000,0.980000,-0.980000,1.000000,0.980000,-1.000000,0.250000,0.980000,-1.000000,-0.750000,0.980000,-1.000000,0.750000,0.980000,-1.000000,0.250000,0.980000,1.000000,0.250000,0.980000,1.000000,1.000000,0.980000,-1.000000,1.000000,0.980000,-1.000000,-0.750000,0.980000,-1.000000,-1.000000,0.980000,-0.980000,1.000000,0.980000,-1.000000,1.000000,1.000000,-1.000000,1.000000,1.000000,-1.000000,-0.750000,1.000000,-1.000000,-1.000000,1.000000,-1.000000,0.250000,1.000000,-1.000000,-0.750000,1.000000,-1.000000,0.750000,1.000000,-1.000000,0.250000,1.000000,-1.000000,0.750000,1.000000,-0.980000,0.750000,0.980000,1.000000,0.750000,0.980000,1.000000,1.000000,1.000000,1.000000,1.000000,0.980000,0.980000,0.250000,0.980000,-0.980000,0.250000,0.980000,-0.980000,0.750000,0.980000,0.980000,-0.750000,0.980000,-0.980000,-0.750000,0.980000,-0.980000,0.250000,1.000000,1.000000,0.250000,1.000000,1.000000,-0.750000,0.980000,1.000000,-0.750000,0.980000,-0.980000,-0.750000,0.980000,0.980000,-0.750000,0.980000,0.980000,-1.000000,1.000000,1.000000,-0.750000,1.000000,0.980000,-0.750000,1.000000,1.000000,-0.750000,1.000000,1.000000,0.250000,1.000000,1.000000,0.250000,1.000000,1.000000,0.750000,1.000000,1.000000,0.750000,1.000000,1.000000,1.000000,1.000000,0.980000,-0.750000,1.000000,-0.980000,-0.750000,1.000000,0.980000,0.250000,1.000000,-0.980000,0.250000,1.000000,-0.980000,-0.750000,1.000000,0.980000,0.750000,1.000000,-0.980000,0.750000,1.000000,-0.980000,0.250000,1.000000,-0.980000,0.750000,1.000000,0.980000,0.750000,1.000000,0.980000,1.000000,0.980000,0.980000,1.000000,0.980000,-0.980000,1.000000,1.000000,-0.980000,1.000000,-0.257500,0.980000,-1.000000,-0.257500,1.000000,-0.750000,-0.257500,1.000000,0.250000,-0.257500,0.980000,0.250000,-0.257500,0.980000,-0.750000,0.237500,1.000000,0.250000,0.237500,0.980000,0.250000,-0.257500,0.980000,0.250000,0.237500,1.000000,-0.750000,0.237500,0.980000,-0.750000,0.237500,0.980000,0.250000,0.237500,1.000000,-1.000000,0.237500,0.980000,-1.000000,0.237500,0.980000,-0.750000,0.485000,0.980000,-0.750000,0.485000,1.000000,-0.750000,0.485000,1.000000,0.250000,0.485000,1.000000,0.750000,0.485000,0.980000,0.750000,0.485000,0.980000,0.250000,0.732500,1.000000,0.750000,0.732500,0.980000,0.750000,0.485000,0.980000,0.750000,0.732500,1.000000,0.250000,0.732500,0.980000,0.250000,0.732500,0.980000,0.750000,0.732500,1.000000,-0.750000,0.732500,0.980000,-0.750000,0.732500,0.980000,0.250000,0.732500,0.980000,-0.750000,0.732500,1.000000,-0.750000,0.485000,1.000000,-0.750000,-0.752500,1.000000,0.250000,-0.752500,0.980000,0.250000,-0.752500,0.980000,-0.750000,-0.752500,1.000000,0.750000,-0.752500,0.980000,0.750000,-0.752500,0.980000,0.250000,-0.752500,0.980000,0.750000,-0.752500,1.000000,0.750000,-0.505000,1.000000,0.750000,-0.505000,1.000000,0.250000,-0.505000,0.980000,0.250000,-0.505000,0.980000,0.750000,-0.505000,0.980000,0.250000,-0.505000,1.000000,0.250000,-0.505000,1.000000,-0.750000,-0.752500,1.000000,-0.750000,-0.752500,0.980000,-0.750000,-0.505000,0.980000,-0.750000,-0.980000,0.980000,1.000000,0.980000,0.980000,1.000000,0.980000,-0.980000,1.000000,0.980000,0.980000,-0.750000,0.980000,1.000000,0.750000,0.485000,0.980000,-0.750000,-0.505000,0.980000,-0.750000,0.732500,0.980000,-0.750000,0.980000,0.980000,0.750000,-0.257500,0.980000,-0.750000,0.980000,0.980000,0.250000,0.485000,0.980000,0.250000,0.980000,0.980000,1.000000,0.732500,0.980000,1.000000,0.485000,0.980000,1.000000,0.485000,0.980000,0.750000,0.237500,0.980000,0.250000,-0.257500,0.980000,1.000000,-0.505000,0.980000,0.250000,-0.505000,0.980000,1.000000,-0.752500,0.980000,1.000000,-0.980000,0.980000,0.250000,-0.505000,0.980000,-0.750000,-0.980000,0.980000,-0.750000,-0.752500,0.980000,-0.750000,0.485000,1.000000,0.750000,-0.505000,1.000000,0.750000,0.980000,1.000000,0.250000,0.732500,1.000000,0.750000,-0.257500,1.000000,0.750000,0.485000,1.000000,0.250000,-0.257500,1.000000,1.000000,0.980000,1.000000,-1.000000,0.732500,1.000000,-1.000000,0.485000,1.000000,-1.000000,0.485000,1.000000,-0.750000,-0.257500,1.000000,-1.000000,-0.505000,1.000000,-1.000000,-0.752500,1.000000,-1.000000,-0.505000,1.000000,0.250000,-0.505000,1.000000,0.750000,-0.980000,1.000000,0.250000,-0.980000,1.000000,0.750000,-0.752500,1.000000,0.750000,0.980000,1.000000,-0.750000,0.980000,1.000000,1.000000,0.485000,0.980000,1.000000,0.485000,1.000000,1.000000,0.237500,1.000000,1.000000,-0.505000,0.980000,1.000000,-0.505000,1.000000,1.000000,-0.980000,0.980000,1.000000,-1.000000,0.980000,1.000000,-1.000000,-0.980000,-0.750000,-0.980000,1.000000,0.750000,-0.980000,0.980000,-0.750000,-1.000000,-0.980000,0.250000,-1.000000,0.980000,1.000000,-0.980000,1.000000,-0.750000,-1.000000,1.000000,-0.750000,-0.980000,1.000000,0.250000,-1.000000,0.980000,-1.000000,-1.000000,0.980000,-0.750000,-1.000000,0.980000,0.250000,-1.000000,1.000000,1.000000,-0.980000,0.980000,0.250000,-0.980000,-0.980000,0.750000,-1.000000,0.980000,0.750000,-0.980000,0.980000,0.750000,-1.000000,-0.980000,0.750000,-1.000000,-1.000000,-0.750000,-0.980000,-0.980000,0.750000,-1.000000,-0.980000,0.750000,0.980000,-0.980000,1.000000,-1.000000,-1.000000,0.750000,-1.000000,-1.000000,0.250000,-0.980000,-0.980000,0.250000,-1.000000,-0.980000,1.000000,0.980000,-1.000000,-0.750000,-0.980000,-1.000000,-1.000000,-0.980000,-1.000000,-0.750000,-0.980000,-1.000000,0.250000,-1.000000,-1.000000,1.000000,0.980000,-1.000000,0.250000,0.980000,-0.980000,0.750000,0.980000,-1.000000,0.750000,-0.980000,-0.980000,-0.750000,-0.980000,-1.000000,0.750000,0.980000,0.980000,1.000000,1.000000,-1.000000,0.250000,0.980000,1.000000,-0.750000,1.000000,-1.000000,0.750000,0.980000,1.000000,0.750000,0.980000,0.980000,1.000000,0.980000,-1.000000,0.750000,1.000000,-1.000000,-0.750000,1.000000,-0.980000,1.000000,1.000000,-0.980000,-1.000000,1.000000,-0.980000,-0.750000,1.000000,-0.980000,0.250000,1.000000,-1.000000,1.000000,1.000000,1.000000,0.750000,0.980000,0.980000,0.750000,0.980000,0.980000,0.250000,0.980000,1.000000,0.250000,0.980000,-0.980000,-1.000000,1.000000,1.000000,-1.000000,1.000000,0.980000,0.250000,1.000000,0.980000,0.750000,1.000000,0.980000,1.000000,1.000000,0.980000,-1.000000,1.000000,0.980000,-0.750000,1.000000,0.980000,0.250000,1.000000,-0.980000,1.000000,1.000000,0.980000,1.000000,-0.257500,0.980000,-0.750000,-0.257500,1.000000,-0.750000,-0.257500,1.000000,0.250000,0.237500,1.000000,0.250000,0.237500,1.000000,-0.750000,0.485000,0.980000,0.250000,0.485000,1.000000,0.250000,0.485000,1.000000,0.750000,0.732500,1.000000,0.750000,0.732500,1.000000,0.250000,0.485000,0.980000,-0.750000,-0.752500,1.000000,-0.750000,-0.752500,1.000000,0.250000,-0.505000,0.980000,0.750000,-0.505000,1.000000,0.750000,-0.505000,0.980000,-0.750000,-0.505000,1.000000,-0.750000,-0.980000,-0.980000,1.000000];
HdrSceneGen.BuildingUvs = [0.703035,0.043241,0.785509,0.905212,0.699027,0.826746,0.177262,0.967068,0.867983,0.909221,0.744272,0.905212,0.946450,0.909221,0.816437,0.950458,0.863975,0.002004,0.744272,0.863975,0.699027,0.867983,0.785509,0.863975,0.740264,0.043241,0.905212,0.002004,0.909221,0.744272,0.744272,0.826746,0.661798,0.826746,0.740264,0.826746,0.867983,0.039233,0.785509,0.867983,0.740264,0.867983,0.826746,0.080470,0.740264,0.909221,0.822738,0.084478,0.080470,0.909221,0.785509,0.826746,0.905212,0.043241,0.826746,0.002004,0.826746,0.414375,0.661798,0.867983,0.867983,0.249427,0.863975,0.043241,0.822738,0.867983,0.080470,0.946450,0.661798,0.084478,0.905212,0.410367,0.822738,0.826746,0.002004,0.946450,0.703035,0.867983,0.496849,0.905212,0.661798,0.905212,0.703035,0.826746,0.084478,0.956759,0.781501,0.826746,0.661798,0.080470,0.822738,0.002004,0.703035,0.039233,0.946450,0.950458,0.744272,0.867983,0.781501,0.043241,0.744272,0.080470,0.905212,0.909221,0.703035,0.002004,0.905212,0.950458,0.950458,0.909221,0.909221,0.909221,0.661798,0.043241,0.781501,0.002004,0.410367,0.919530,0.785509,0.080470,0.816437,0.909221,0.867983,0.744272,0.492841,0.867983,0.699027,0.002004,0.785509,0.002004,0.909221,0.950458,0.575316,0.909221,0.822738,0.043241,0.781501,0.867983,0.496849,0.946450,0.987687,0.987687,0.414375,0.946450,0.699027,0.043241,0.744272,0.043241,0.744272,0.002004,0.909221,0.987687,0.867983,0.950458,0.867983,0.084478,0.946450,0.410367,0.740264,0.002004,0.826746,0.084478,0.208190,0.967068,0.960767,0.039233,0.971076,0.043241,0.863975,0.084478,0.080470,0.967068,0.327893,0.496849,0.987687,0.080470,0.977377,0.740264,0.977377,0.579324,0.327893,0.826746,0.410367,0.909221,0.327893,0.863975,0.657790,0.740264,0.162944,0.496849,0.826746,0.410367,0.410367,0.915522,0.166952,0.822738,0.905212,0.414375,0.744272,0.822738,0.785509,0.166952,0.960767,0.579324,0.822738,0.166952,0.997996,0.249427,0.740264,0.956759,0.239117,0.929839,0.235109,0.929839,0.971076,0.744272,0.235109,0.967068,0.492841,0.971076,0.950458,0.249427,0.744272,0.492841,0.657790,0.331901,0.657790,0.080470,0.657790,0.002004,0.785509,0.492841,0.960767,0.905212,0.002004,0.331901,0.657790,0.781501,0.331901,0.084478,0.909221,0.414375,0.775200,0.987687,0.750573,0.950458,0.657790,0.977377,0.956759,0.084478,0.754581,0.950458,0.812429,0.950458,0.327893,0.919530,0.812429,0.987687,0.991695,0.826746,0.795818,0.946450,0.967068,0.022623,0.960767,0.022623,0.822738,0.950458,0.795818,0.909221,0.791810,0.909221,0.162944,0.967068,0.822738,0.987687,0.496849,0.977377,0.575316,0.977377,0.867983,0.043241,0.867983,0.080470,0.826746,0.043241,0.946450,0.905212,0.946450,0.744272,0.657790,0.905212,0.657790,0.867983,0.867983,0.002004,0.826746,0.039233,0.703035,0.905212,0.863975,0.492841,0.863975,0.414375,0.822738,0.162944,0.946450,0.080470,0.946450,0.002004,0.909221,0.002004,0.703035,0.863975,0.661798,0.863975,0.162944,0.956759,0.162944,0.919530,0.905212,0.249427,0.579324,0.946450,0.740264,0.946450,0.703035,0.080470,0.987687,0.909221,0.661798,0.002004,0.661798,0.039233,0.785509,0.043241,0.492841,0.946450,0.492841,0.909221,0.946450,0.245419,0.946450,0.084478,0.785509,0.039233,0.744272,0.039233,0.331901,0.905212,0.492841,0.905212,0.867983,0.987687,0.909221,0.946450,0.863975,0.987687,0.863975,0.826746,0.826746,0.826746,0.575316,0.946450,0.946450,0.249427,0.909221,0.249427,0.331901,0.956759,0.410367,0.956759,0.867983,0.946450,0.905212,0.905212,0.905212,0.744272,0.183563,0.929839,0.177262,0.929839,0.173254,0.929839,0.166952,0.929839,0.166952,0.967068,0.204182,0.929839,0.197880,0.929839,0.197880,0.967068,0.080470,0.956759,0.080470,0.950458,0.002004,0.950458,0.193872,0.929839,0.187571,0.929839,0.187571,0.967068,0.967068,0.043241,0.960767,0.043241,0.960767,0.080470,0.956759,0.043241,0.950458,0.043241,0.950458,0.080470,0.967068,0.032932,0.960767,0.032932,0.987687,0.043241,0.981385,0.043241,0.002004,0.826746,0.166952,0.496849,0.084478,0.909221,0.971076,0.579324,0.977377,0.080470,0.977377,0.043241,0.249427,0.956759,0.327893,0.956759,0.327893,0.950458,0.224800,0.929839,0.218499,0.929839,0.218499,0.967068,0.967068,0.084478,0.960767,0.084478,0.960767,0.245419,0.080470,0.960767,0.002004,0.960767,0.214491,0.929839,0.208190,0.929839,0.002004,0.496849,0.002004,0.822738,0.657790,0.863975,0.657790,0.826746,0.331901,0.826746,0.867983,0.414375,0.867983,0.740264,0.657790,0.661798,0.331901,0.661798,0.822738,0.496849,0.744272,0.496849,0.245419,0.967068,0.245419,0.929839,0.331901,0.002004,0.228808,0.929839,0.967068,0.579324,0.414375,0.977377,0.492841,0.977377,0.977377,0.905212,0.977377,0.744272,0.657790,0.492841,0.331901,0.331901,0.956759,0.032932,0.950458,0.032932,0.950458,0.039233,0.802120,0.950458,0.795818,0.950458,0.795818,0.987687,0.740264,0.950458,0.579324,0.950458,0.991695,0.249427,0.991695,0.327893,0.791810,0.950458,0.785509,0.950458,0.785509,0.987687,0.327893,0.492841,0.327893,0.331901,0.781501,0.166952,0.744272,0.166952,0.657790,0.162944,0.657790,0.084478,0.987687,0.249427,0.950458,0.575316,0.657790,0.744272,0.331901,0.744272,0.863975,0.822738,0.863975,0.496849,0.826746,0.496849,0.166952,0.925831,0.327893,0.925831,0.997996,0.905212,0.997996,0.826746,0.575316,0.971076,0.960767,0.028924,0.806128,0.950458,0.760883,0.987687,0.760883,0.950458,0.956759,0.022623,0.950458,0.022623,0.950458,0.028924,0.744272,0.950458,0.744272,0.987687,0.950458,0.084478,0.950458,0.245419,0.657790,0.971076,0.579324,0.971076,0.781501,0.950458,0.775200,0.950458,0.771192,0.987687,0.771192,0.950458,0.764891,0.950458,0.740264,0.492841,0.740264,0.166952,0.661798,0.166952,0.331901,0.657790,0.657790,0.657790,0.657790,0.496849,0.987687,0.245419,0.987687,0.084478,0.981385,0.084478,0.002004,0.905212,0.327893,0.905212,0.327893,0.867983,0.802120,0.909221,0.977377,0.084478,0.971076,0.084478,0.971076,0.245419,0.162944,0.960767,0.084478,0.960767,0.785509,0.909221,0.785509,0.946450,0.946450,0.740264,0.946450,0.414375,0.331901,0.327893,0.657790,0.327893,0.657790,0.166952,0.740264,0.822738,0.740264,0.496849,0.661798,0.496849,0.331901,0.822738,0.657790,0.822738,0.657790,0.785509,0.956759,0.905212,0.956759,0.579324,0.950458,0.579324,0.822738,0.909221,0.816437,0.946450,0.575316,0.956759,0.575316,0.950458,0.414375,0.950458,0.997996,0.579324,0.991695,0.579324,0.991695,0.657790,0.575316,0.967068,0.575316,0.960767,0.414375,0.960767,0.812429,0.909221,0.806128,0.909221,0.806128,0.946450,0.987687,0.744272,0.981385,0.744272,0.981385,0.905212,0.327893,0.946450,0.327893,0.940148,0.249427,0.940148,0.760883,0.909221,0.754581,0.909221,0.754581,0.946450,0.997996,0.496849,0.991695,0.496849,0.991695,0.575316,0.740264,0.967068,0.740264,0.960767,0.579324,0.960767,0.750573,0.909221,0.744272,0.909221,0.744272,0.946450,0.987687,0.579324,0.981385,0.579324,0.981385,0.740264,0.327893,0.936140,0.327893,0.929839,0.249427,0.929839,0.781501,0.909221,0.775200,0.909221,0.775200,0.946450,0.997996,0.909221,0.991695,0.909221,0.991695,0.987687,0.410367,0.967068,0.410367,0.960767,0.249427,0.960767,0.771192,0.909221,0.764891,0.909221,0.764891,0.946450,0.327893,0.002004,0.002004,0.002004,0.002004,0.327893,0.822738,0.905212,0.781501,0.905212,0.822738,0.863975,0.781501,0.863975,0.905212,0.080470,0.002004,0.909221,0.863975,0.080470,0.909221,0.905212,0.496849,0.867983,0.905212,0.039233,0.863975,0.039233,0.740264,0.905212,0.826746,0.492841,0.661798,0.162944,0.699027,0.905212,0.909221,0.080470,0.740264,0.863975,0.699027,0.863975,0.084478,0.919530,0.867983,0.410367,0.579324,0.909221,0.740264,0.080470,0.699027,0.080470,0.740264,0.039233,0.950458,0.987687,0.699027,0.039233,0.822738,0.080470,0.414375,0.909221,0.867983,0.245419,0.781501,0.080470,0.822738,0.039233,0.781501,0.039233,0.331901,0.867983,0.946450,0.987687,0.905212,0.987687,0.946450,0.946450,0.826746,0.987687,0.496849,0.909221,0.909221,0.410367,0.331901,0.919530,0.905212,0.946450,0.867983,0.905212,0.183563,0.967068,0.173254,0.967068,0.204182,0.967068,0.002004,0.956759,0.193872,0.967068,0.967068,0.080470,0.956759,0.080470,0.967068,0.039233,0.863975,0.410367,0.981385,0.080470,0.002004,0.863975,0.327893,0.822738,0.084478,0.915522,0.971076,0.740264,0.971076,0.080470,0.249427,0.950458,0.224800,0.967068,0.967068,0.245419,0.002004,0.967068,0.214491,0.967068,0.162944,0.822738,0.331901,0.863975,0.905212,0.740264,0.331901,0.740264,0.822738,0.822738,0.239117,0.967068,0.331901,0.080470,0.228808,0.967068,0.967068,0.905212,0.414375,0.971076,0.971076,0.905212,0.331901,0.492841,0.956759,0.039233,0.822738,0.492841,0.802120,0.987687,0.579324,0.956759,0.997996,0.327893,0.791810,0.987687,0.002004,0.492841,0.781501,0.492841,0.331901,0.162944,0.987687,0.575316,0.331901,0.781501,0.826746,0.822738,0.166952,0.919530,0.816437,0.987687,0.991695,0.905212,0.496849,0.971076,0.967068,0.028924,0.806128,0.987687,0.754581,0.987687,0.956759,0.028924,0.750573,0.987687,0.956759,0.245419,0.579324,0.977377,0.781501,0.987687,0.764891,0.987687,0.661798,0.492841,0.331901,0.496849,0.981385,0.245419,0.002004,0.867983,0.802120,0.946450,0.977377,0.245419,0.084478,0.967068,0.791810,0.946450,0.909221,0.740264,0.331901,0.166952,0.661798,0.822738,0.331901,0.785509,0.950458,0.905212,0.822738,0.946450,0.414375,0.956759,0.997996,0.657790,0.414375,0.967068,0.812429,0.946450,0.987687,0.905212,0.249427,0.946450,0.760883,0.946450,0.997996,0.575316,0.579324,0.967068,0.750573,0.946450,0.987687,0.740264,0.249427,0.936140,0.781501,0.946450,0.997996,0.987687,0.249427,0.967068,0.771192,0.946450,0.327893,0.327893];
HdrSceneGen.BuildingIndices = [32,19,1,68,48,5,36,25,11,43,15,9,26,140,141,37,33,24,31,142,21,143,144,14,39,145,146,13,147,18,8,27,148,20,38,149,150,151,28,152,23,34,10,29,40,153,154,155,17,41,156,2,16,157,42,158,159,35,160,30,161,162,22,12,0,163,72,56,44,79,52,46,70,164,54,63,165,166,67,167,59,71,168,169,170,171,77,49,73,50,45,64,172,57,74,173,174,175,62,47,65,75,53,76,176,6,55,177,178,179,180,69,181,66,78,182,183,184,185,58,51,4,186,187,188,61,189,190,3,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,82,84,80,95,87,211,212,90,213,92,86,214,97,96,91,215,88,89,216,217,218,83,219,220,221,222,223,224,225,226,227,85,228,229,230,231,81,94,232,233,234,235,236,98,237,238,93,239,240,241,242,99,243,244,105,113,114,245,108,106,246,247,101,116,248,249,109,250,251,107,252,112,253,254,255,256,102,100,115,257,258,259,104,260,261,103,262,263,264,265,266,267,268,117,269,270,111,271,272,119,273,110,274,118,275,276,277,278,279,280,281,127,137,133,7,282,283,129,138,139,284,131,132,285,128,126,286,287,288,125,289,290,291,122,292,293,124,294,295,123,296,297,298,299,121,300,301,302,303,304,305,306,307,308,309,310,311,312,313,314,315,134,130,316,317,318,136,319,320,135,321,322,323,324,120,325,326,327,328,329,330,331,332,333,334,335,336,337,60,338,339,340,341,342,343,344,345,346,347,348,349,350,351,352,353,354,355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,388,389,390,32,1,391,68,5,392,36,11,393,43,9,394,26,141,395,37,24,396,31,21,397,143,14,398,39,146,399,13,18,400,8,148,401,20,149,402,150,28,403,152,34,404,10,40,405,153,155,406,17,156,407,2,157,408,42,159,409,35,30,410,161,22,411,12,163,412,72,44,413,79,46,414,70,54,415,63,166,416,67,59,417,71,169,418,170,77,419,49,50,420,45,172,421,57,173,422,174,62,423,47,75,424,53,176,425,6,177,426,178,180,427,69,66,428,78,183,429,184,58,430,51,186,431,187,61,432,189,3,433,191,193,434,194,196,435,197,199,436,200,202,437,203,205,438,206,208,439,209,82,440,84,95,441,87,212,92,213,442,443,86,97,444,96,215,445,88,216,446,217,83,447,219,221,448,222,224,449,225,227,450,85,229,451,230,81,452,94,233,453,234,236,454,98,238,455,93,240,456,241,99,457,243,105,458,113,245,459,108,246,460,247,116,461,248,109,462,250,107,463,252,253,464,254,256,465,102,115,466,257,259,467,104,261,468,103,263,469,264,266,470,267,117,471,269,111,472,271,119,473,273,274,474,118,276,475,277,279,476,280,127,477,137,7,478,282,129,479,138,284,480,131,285,481,128,286,482,287,125,483,289,291,484,122,293,485,124,295,486,123,297,487,298,121,488,300,302,489,303,305,490,306,308,491,309,311,492,312,314,493,315,130,494,316,318,495,136,320,496,135,322,497,323,120,498,325,327,499,328,330,500,331,333,501,334,336,502,337,338,503,339,341,504,342,344,505,345,347,506,348,350,507,351,353,508,354,356,509,357,359,510,360,362,511,363,365,512,366,368,513,369,371,514,372,374,515,375,377,516,378,380,517,381,383,518,384,386,519,387,389]

// Geometry for the ground entity
HdrSceneGen.GroundVertices = [1.000000,-1.000000,0.000000,-1.000000,-1.000000,0.000000,1.000000,1.000000,0.000000,-1.000000,1.000000,0.000000];
HdrSceneGen.GroundUVs = [12.999998,-12.000000,-11.999998,-12.000000,12.999998,13.000000,-11.999998,12.999997];
HdrSceneGen.GroundIndices = [2,3,1,0,2,1];

// Geometry for the skybox entity
HdrSceneGen.SkyboxVertices = [-1.000000,-1.000000,-1.000000,-1.000000,1.000000,-1.000000,1.000000,1.000000,-1.000000,1.000000,-1.000000,-1.000000,-1.000000,-1.000000,1.000000,-1.000000,1.000000,1.000000,1.000000,1.000000,1.000000,1.000000,-1.000000,1.000000,-1.000000,1.000000,1.000000,-1.000000,-1.000000,-1.000000,-1.000000,1.000000,-1.000000,-1.000000,1.000000,1.000000,-1.000000,1.000000,-1.000000,-1.000000,-1.000000,1.000000];
HdrSceneGen.SkyboxUVs = [0.750000,0.333783,1.000000,0.333783,0.250000,0.333783,0.500000,0.333783,0.750000,0.666217,1.000000,0.666217,0.250000,0.666217,0.500000,0.666217,0.000000,0.666217,0.500000,0.001350,0.250000,0.001350,0.250000,0.998650,0.000000,0.333783,0.500000,0.998650];
HdrSceneGen.SkyboxIndices = [4,5,1,8,6,2,6,7,3,4,0,7,9,10,2,7,6,11,0,4,1,12,8,2,2,6,3,7,0,3,3,9,2,13,7,11];


/// <summary>
/// Function creates the VBO objects used in the scene.
/// </summary>
HdrSceneGen.Create = function ()
{
	// Array to store the list of entities in the scene.
	var entity = new Array();

	// Create building VBO
	var buildingMesh = new PolygonMesh();
	buildingMesh.Create(HdrSceneGen.BuildingVertices.length / 3, HdrSceneGen.BuildingIndices.length);
	for (var i = 0; i < HdrSceneGen.BuildingVertices.length; ++i)
		buildingMesh.VertexPoint[i] = HdrSceneGen.BuildingVertices[i];
	for (var i = 0; i < HdrSceneGen.BuildingUvs.length; ++i)
	{
		buildingMesh.UV[i] = HdrSceneGen.BuildingUvs[i];
		if ( i & 0x01 == 1 )
			buildingMesh.UV[i] = 1.0 - buildingMesh.UV[i];
	}
	for (var i = 0; i < HdrSceneGen.BuildingIndices.length; ++i)
		buildingMesh.Index[i] = HdrSceneGen.BuildingIndices[i];
	//buildingMesh.CreateNormals();
	var buildingVbo = new GLVertexBufferObject();
	buildingVbo.Create(buildingMesh);
	
	
	// Create ground VBO
	var groundMesh = new PolygonMesh();
	groundMesh.Create(HdrSceneGen.GroundVertices.length / 3, HdrSceneGen.GroundIndices.length);
	for (var i = 0; i < HdrSceneGen.GroundVertices.length; ++i)
		groundMesh.VertexPoint[i] = HdrSceneGen.GroundVertices[i];
	for (var i = 0; i < HdrSceneGen.GroundUVs.length; ++i)
	{
		groundMesh.UV[i] = HdrSceneGen.GroundUVs[i];
		if ( i & 0x01 == 1 )
			groundMesh.UV[i] = 1.0 - groundMesh.UV[i];
	}
	for (var i = 0; i < HdrSceneGen.GroundIndices.length; ++i)
		groundMesh.Index[i] = HdrSceneGen.GroundIndices[i];
	//groundMesh.CreateNormals();
	var groundVbo = new GLVertexBufferObject();
	groundVbo.Create(groundMesh);
	
	
	// Create skybox VBO
	var skyboxMesh = new PolygonMesh();
	skyboxMesh.Create(HdrSceneGen.SkyboxVertices.length / 3, HdrSceneGen.SkyboxIndices.length);
	for (var i = 0; i < HdrSceneGen.SkyboxVertices.length; ++i)
		skyboxMesh.VertexPoint[i] = HdrSceneGen.SkyboxVertices[i];
	for (var i = 0; i < HdrSceneGen.SkyboxUVs.length; ++i)
	{
		skyboxMesh.UV[i] = HdrSceneGen.SkyboxUVs[i];
		if ( i & 0x01 == 1 )
			skyboxMesh.UV[i] = 1.0 - skyboxMesh.UV[i];
	}
	for (var i = 0; i < HdrSceneGen.SkyboxIndices.length; ++i)
		skyboxMesh.Index[i] = HdrSceneGen.SkyboxIndices[i];
	//skyboxMesh.CreateNormals();
	var skyboxVbo = new GLVertexBufferObject();
	skyboxVbo.Create(skyboxMesh);
	
	
	// Create building entity
	var buildingEntity = new Entity();
	buildingEntity.ObjectEntity = buildingVbo;
	buildingEntity.ObjectMatrix.Translate(0.0, 2.0, 0.0);
	buildingEntity.ObjectMatrix.Rotate(-90.0, 0.0, 0.0);
	buildingEntity.ObjectMatrix.Scale(10.0, 10.0, 2.0);
	entity.push(buildingEntity);
	
	// Create ground entity
	var groundEntity = new Entity();
	groundEntity.ObjectEntity = groundVbo;
	groundEntity.ObjectMatrix.Translate(0.0, 0.0, 0.0);
	groundEntity.ObjectMatrix.Rotate(-90.0, 0.0, 0.0);
	groundEntity.ObjectMatrix.Scale(412.0, 412.0, 1.0);
	entity.push(groundEntity);
	
	// Create skybox entity
	var skyboxEntity = new Entity();
	skyboxEntity.ObjectEntity = skyboxVbo;
	skyboxEntity.ObjectMatrix.Translate(0.0, 1.0, 0.0);
	skyboxEntity.ObjectMatrix.Rotate(-90.0, 0.0, 0.0);
	skyboxEntity.ObjectMatrix.Scale(512.0, 512.0, 512.0);
	entity.push(skyboxEntity);
	
	return entity;
}