/// <summary>
/// Nutty Software Open WebGL Framework
/// 
/// Copyright (C) 2012 Nathaniel Meyer
/// Nutty Software, http://www.nutty.ca
/// All Rights Reserved.
/// 
/// Permission is hereby granted, free of charge, to any person obtaining a copy of
/// this software and associated documentation files (the "Software"), to deal in
/// the Software without restriction, including without limitation the rights to
/// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
/// of the Software, and to permit persons to whom the Software is furnished to do
/// so, subject to the following conditions:
///     1. The above copyright notice and this permission notice shall be included in all
///        copies or substantial portions of the Software.
///     2. Redistributions in binary or minimized form must reproduce the above copyright
///        notice and this list of conditions in the documentation and/or other materials
///        provided with the distribution.
/// 
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
/// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
/// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
/// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
/// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
/// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
/// SOFTWARE.
/// </summary>


/// <summary>
/// This script is responsible for creating the scene entities for the demo.
/// </summary>


/// <summary>
/// Constructor.
/// </summary>
function GlowSceneGen ()
{
}


/// <summary>
/// Function creates the VBO objects used in the scene.
/// </summary>
GlowSceneGen.Create = function ()
{
	// Array to store the list of entities in the scene.
	var entity = new Array();

	// Create scene content
	var cubeMesh = new Cube(1.0, 1.0, 1.0);
	// Invert cube normals because we're inside the cube
	for (var i = 0; i < cubeMesh.Normal.length; ++i)
		cubeMesh.Normal[i] = -cubeMesh.Normal[i];
	var cubeVbo = new GLVertexBufferObject();
	cubeVbo.Create(cubeMesh);
	
	var cubeFloorMesh = new Cube(1.0, 1.0, 1.0);
	var cubeFloorVbo = new GLVertexBufferObject();
	cubeFloorVbo.Create(cubeFloorMesh);
	
	var sphereMesh = new Sphere(10, 10, 1.0, 0.0);
	var sphereVbo = new GLVertexBufferObject();
	sphereVbo.Create(sphereMesh);
	
	var torusMesh = new Torus(24, 24, 0.25, 1.0);
	var torusVbo = new GLVertexBufferObject();
	torusVbo.Create(torusMesh);
	
	var torusMesh2 = new Torus(24, 24, 0.1, 1.0);
	var torusVbo2 = new GLVertexBufferObject();
	torusVbo2.Create(torusMesh2);

	
	// Create floor panels
	var count = 10;
	var scale = new Point(1.0, 0.1, 1.0);
	var spread = 1.1;
	var offsetX = count * spread * scale.x * 0.75;
	var offsetZ = count * spread * scale.z * 0.75;
	
	for (var z = 0; z < count; ++z)
	{
		for (var x = 0; x < count; ++x)
		{
			var floorPanelEntity = new Entity();
			floorPanelEntity.ObjectEntity = cubeFloorVbo;
			floorPanelEntity.ObjectMaterial.Ambient.SetPoint(0.0, 0.0, 0.0);
			floorPanelEntity.ObjectMaterial.Specular.SetPoint(0.0, 0.0, 0.0);
			floorPanelEntity.ObjectMatrix.Translate(x * spread * scale.x * 2.0 - offsetX, 0.0 * scale.y * 2.0, z * spread * scale.z * 2.0 - offsetZ);
			floorPanelEntity.ObjectMatrix.Scale(scale.x, scale.y, scale.z);
			entity.push(floorPanelEntity);
		}
	}
	
	// Create a torus entities
	var torusEntity = new Entity();
	torusEntity.ObjectEntity = torusVbo;
	torusEntity.ObjectMaterial.Ambient.SetPoint(0.0, 0.0, 0.0);
	torusEntity.ObjectMatrix.Translate(0.0, 0.0, 0.0);
	torusEntity.ObjectMatrix.Scale(2.0, 2.0, 2.0);
	entity.push(torusEntity);
	
	for (var i = 0; i < 4; ++i)
	{
		// Create rings on the ceiling
		var torusEntity = new Entity();
		torusEntity.ObjectEntity = torusVbo2;
		torusEntity.ObjectMaterial.Ambient.SetPoint(0.0, 0.0, 0.0);
		torusEntity.ObjectMatrix.Translate(0.0, 4.0, 0.0);
		torusEntity.ObjectMatrix.Rotate(90.0, 0.0, 0.0);
		torusEntity.ObjectMatrix.Scale(1.0 * i * 1.1 + 1.0, 1.0 * i * 1.1 + 1.0, 1.5);
		entity.push(torusEntity);
	}
	
	// Create a sphere entity (disco ball)
	var sphereEntity = new Entity();
	sphereEntity.ObjectEntity = sphereVbo;
	sphereEntity.ObjectMaterial.Ambient.SetPoint(0.0, 0.0, 0.0);
	sphereEntity.ObjectMatrix.Translate(0.0, 4.0, 0.0);
	sphereEntity.ObjectMatrix.Scale(1.0, 1.0, 1.0);
	entity.push(sphereEntity);
	
	// Create a cube entity (room)
	var cubeEntity = new Entity();
	cubeEntity.ObjectEntity = cubeVbo;
	cubeEntity.ObjectMaterial.Ambient.SetPoint(0.05, 0.05, 0.05);
	cubeEntity.ObjectMatrix.Translate(0.0, 1.9, 0.0);
	cubeEntity.ObjectMatrix.Scale(12.0, 2.0, 12.0);
	entity.push(cubeEntity);
	
	return entity;
}