/// <summary>
/// Nutty Software Open WebGL Framework
/// 
/// Copyright (C) 2012 Nathaniel Meyer
/// Nutty Software, http://www.nutty.ca
/// All Rights Reserved.
/// 
/// Permission is hereby granted, free of charge, to any person obtaining a copy of
/// this software and associated documentation files (the "Software"), to deal in
/// the Software without restriction, including without limitation the rights to
/// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
/// of the Software, and to permit persons to whom the Software is furnished to do
/// so, subject to the following conditions:
///     1. The above copyright notice and this permission notice shall be included in all
///        copies or substantial portions of the Software.
///     2. Redistributions in binary or minimized form must reproduce the above copyright
///        notice and this list of conditions in the documentation and/or other materials
///        provided with the distribution.
/// 
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
/// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
/// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
/// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
/// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
/// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
/// SOFTWARE.
/// </summary>


/// <summary>
/// Blur shader uses the separable bluring algorithm to blur a single image.
/// </summary>


/// <summary>
/// Constructor.
/// </summary>
function BlurShader ()
{
	/// <summary>
	/// Setup inherited members.
	/// </summary>
	ImageShader.call(this);
	
	
	/// <summary>
	/// Shader variables.
	/// </summary>
	this.mOrientationId;
	this.mBlurAmountId;
	this.mBlurStrengthId;


	/// <summary>
	/// Horizontal (= 0) or vertical (= 1) blur orientation.
	/// </summary>
	this.Orientation = 0;
	
	
	/// <summary>
	/// Maximum amount of bluring to perform.
	/// </summary>
	this.BlurAmount = 10;
	
	
	/// <summary>
	/// Sets the amount of pixel offset when blurring. Larger values increase the
	/// blur radius at the expense of quality (banding artifacts).
	/// </summary>
	this.BlurScale = 1.0;
	
	
	/// <summary>
	/// Sets the strength of the blur (smooth = 0  vs coarse = 1 falloff).
	/// </summary>
	this.BlurStrength = 0.2;
}


/// <summary>
/// Prototypal Inheritance.
/// </summary>
BlurShader.prototype = new ImageShader();
BlurShader.prototype.constructor = BlurShader;


/// <summary>
/// Implementation.
/// </summary>
BlurShader.prototype.Init = function ()
{
	ImageShader.prototype.Init.call(this);
	
	// Get variables
	this.mOrientationId = this.GetVariable("Orientation");
	this.mBlurAmountId = this.GetVariable("BlurAmount");
	this.mBlurScaleId = this.GetVariable("BlurScale");
	this.mBlurStrengthId = this.GetVariable("BlurStrength");
}


/// <summary>
/// Implementation.
/// </summary>
BlurShader.prototype.Draw = function (entity)
{
	// Set Orientation
	this.SetVariableInt(this.mOrientationId, this.Orientation);
	this.SetVariableInt(this.mBlurAmountId, this.BlurAmount);
	this.SetVariable(this.mBlurScaleId, this.BlurScale);
	this.SetVariable(this.mBlurStrengthId, this.BlurStrength);


	// Draw
	ImageShader.prototype.Draw.call(this, entity);
}